#include "General.h"
#include "ClanwarOrFunwar.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"
#include "GameObjManager.h"
#include "SmartGameObj.h"
#include "cPlayer.h"

#define GDI 1
#define NOD 0

#define RESET_MATCH_CUSTOM 2
#define GREEN "104,234,40"

// Uses CMSGP if scripts verion supports it, otherwise uses PPAGE
void PPage(int ID, const char* rgb_colour, const char *Format, ...)
{
	if ( (ID < 1) || (ID > 128) ) return;
	if (!Get_GameObj(ID)) return;

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if (Version < 2.9)
	{
		Console("PPAGE %d %s", ID, buffer);
	}
	else
	{
		Console("CMSGP %d %s %s", ID, rgb_colour, buffer);
	}
}

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Console_Input(buffer);
}

void Reset_Match()
{
	MatchIsStarting = true;
	GameObject *timerthing = Find_Object_With_Script("Reset_Match_Funwar_Or_Clanwar_Timer");
	Commands->Send_Custom_Event(0, timerthing, RESET_MATCH_CUSTOM, 1, 0.5f);
}

int Get_Team_Player_Count_Working(int Team)
{
	int Total = 0;

	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();

		if (p->IsActive)
		{
			int ID = p->PlayerId;
			if (Get_Team(ID) == Team)
			{
				Total++;
			}
		}
	}
	return Total;
}

bool Did_Every_Player_Decide_Clanwars()
{
	// Make sure every team has at least one player
	if (Get_Team_Player_Count_Working(NOD) < 1) return false;
	if (Get_Team_Player_Count_Working(GDI) < 1) return false;

	bool Found = false;
	// Go over every player in-game
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
		StringClass PlayerName = p->PlayerName.Peek_Buffer();
		int Count = ClanwarList.Count();
		// Check if their name is in the ReadyList
		for (int i = 0; i < Count; i++)
		{
			if (strcmp(ClanwarList[i], PlayerName) == 0)
			{
				Found = true;
				break;
			}
		}
		// If name not in ReadyList return false
		if (Found != true)
		{
			// Small memory leak here because delete []PlayerName is missing
			return false;
		}
		Found = false;
	}
	// Return true if every player was found
	return true;
}

bool Did_Every_Player_Decide_Funwars()
{
	// Make sure every team has at least one player
	if (Get_Team_Player_Count_Working(NOD) < 1) return false;
	if (Get_Team_Player_Count_Working(GDI) < 1) return false;

	bool Found = false;
	// Go over every player in-game
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
		StringClass PlayerName = p->PlayerName.Peek_Buffer();
		int Count = FunwarList.Count();
		// Check if their name is in the list
		for (int i = 0; i < Count; i++)
		{
			if (strcmp(FunwarList[i], PlayerName) == 0)
			{
				Found = true;
				break;
			}
		}
		// If name not in ReadyList return false
		if (Found != true)
		{
			// Small memory leak here because delete []PlayerName is missing
			return false;
		}
		Found = false;
	}
	// Return true if every player was found
	return true;
}

void Kill_Harvester(int Team)
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (o->As_VehicleGameObj())
			{
				int TeamType = Commands->Get_Player_Type(o);
				if (TeamType == Team)
				{
					if (Is_Harvester(o) || Is_Harvester_Preset(o))
					{
						Commands->Destroy_Object(o);
						//Commands->Apply_Damage(o,99999,"Death",0); // this spams irc with killed messages
					}					
				}
			}
		}
		x = x->Next();
	}
}

// Loop over every player, kill them and reset their stats
void Kill_And_Reset_All_Players()
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (Commands->Is_A_Star(o))
			{
				cPlayer* Data = Find_Player(Get_Player_ID(o));

				Commands->Destroy_Object(o);
				//Commands->Apply_Damage(o,99999,"Death",0); // this spams irc with killed messages
				Data->Reset_Player();
				Data->Set_Money(StartingCredits);
			}
		}
		x = x->Next();
	}
}

void Reset_Deaths_All_Players()
{
	SLNode<SmartGameObj> *x = GameObjManager::SmartGameObjList.Head();
	while (x)
	{
		GameObject *o = x->Data();
		if (o)
		{
			if (Commands->Is_A_Star(o))
			{
				cPlayer* Data = Find_Player(Get_Player_ID(o));
				Data->Deaths = 0;
			}
		}
		x = x->Next();
	}
}

ClanwarOrFunwar::ClanwarOrFunwar()
{
	RegisterEvent(EVENT_CHAT_HOOK,this);
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

ClanwarOrFunwar::~ClanwarOrFunwar()
{
	UnregisterEvent(EVENT_CHAT_HOOK,this);
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

bool ClanwarOrFunwar::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (!MatchHasStarted)
	{
		WideStringClass MsgString = Message;
		if ( MsgString[0] == L'!')
		{
			if ( MsgString == L"!clanwar")
			{
				PPage(PlayerID, GREEN, "You typed in \"!clanwar\", running check to see if all other players did too...");
				ClanwarList.Add(Get_Player_Name_By_ID(PlayerID));
				if (Did_Every_Player_Decide_Clanwars() == true)
				{
					Console("msg Game match type has been set to CLANWAR, the match will now start soon.");
					Reset_Match();
				}
			}
			else if ( MsgString == L"!funwar")
			{
				PPage(PlayerID, GREEN, "You typed in \"!funwar\", running check to see if all other players did too...");
				FunwarList.Add(Get_Player_Name_By_ID(PlayerID));
				if (Did_Every_Player_Decide_Funwars() == true)
				{
					Console("msg Game match type has been set to FUNWAR, the match will now start soon.");
					Reset_Match();
				}
			}
		}
		else 
		{
			PPage(PlayerID, GREEN, "You can't move and the match won't start until every player");
			PPage(PlayerID, GREEN, "decided on \"!funwar\" or \"!clanwar\" (NOT BOTH).");
		}
	}
	return true;
}

void ClanwarOrFunwar::OnObjectCreate(void *data,GameObject *obj)
{
	if ((Commands->Is_A_Star(obj)) && !MatchHasStarted)
	{
		Commands->Control_Enable(obj, false);
	}
}

void ClanwarOrFunwar::OnLoadLevel()
{
	MatchHasStarted = false;
	MatchIsStarting = false;
	TimeLimit = (int)The_Game()->Get_Time_Remaining_Seconds();
	StartingCredits = (float)The_Cnc_Game()->StartingCredits;

	FunwarList.Delete_All();
	ClanwarList.Delete_All();

	GameObject* obj = Commands->Create_Object("Invisible_Object", Vector3(0.0f,0.0f,0.0f));
	Attach_Script_Once(obj, "Reset_Match_Funwar_Or_Clanwar_Timer","");
}

void Reset_Match_Timer::Created(GameObject *obj)
{
	// Start the timer loop that shows a PSA about typing in !funwar or !clanwar
	Commands->Start_Timer(obj, this,(float)8.0f, 16);
	Commands->Start_Timer(obj, this,(float)20.0f, 16);
	Commands->Start_Timer(obj, this,(float)30.0f, 16);
}

void Reset_Match_Timer::Timer_Expired(GameObject *obj, int number)
{
	if (number == 15)
	{
		if (MatchHasStarted) return;
		MatchHasStarted = true;

		Kill_And_Reset_All_Players();
		Kill_Harvester(NOD);
		Kill_Harvester(GDI);

//		The_Game()->Set_Time_Remaining_Seconds(TimeLimit); // 30 minutes
		Console("time %d", TimeLimit); // Does the same thing as above, I don't think the above thing works correctly

		Commands->Start_Timer(obj, this, 4.0f, 35);
	}

	if (number == 35)
	{
		Reset_Deaths_All_Players();
	}

	else if (number == 16)
	{
		if (MatchIsStarting) return;
		Console("MSG The match will start after all players have typed in and agreed on either \"!funwar\" or \"!clanwar\".");
	}

	else if (number == 1)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 90 seconds.");
		Commands->Start_Timer(obj, this, 30.0f, 2);
	}
	else if (number == 2)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 60 seconds.");
		Commands->Start_Timer(obj, this, 30.0f, 3);
	}
	else if (number == 3)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 30 seconds.");
		Commands->Start_Timer(obj, this, 10.0f, 4);
	}
	else if (number == 4)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 20 seconds.");
		Commands->Start_Timer(obj, this, 10.0f, 5);
	}
	else if (number == 5)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 10 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 6);
	}
	else if (number == 6)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 9 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 7);
	}
	else if (number == 7)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 8 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 8);
	}
	else if (number == 8)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 7 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 9);
	}
	else if (number == 9)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 6 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 10);
	}
	else if (number == 10)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 5 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 11);
	}
	else if (number == 11)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 4 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 12);
	}
	else if (number == 12)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 3 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 13);
	}
	else if (number == 13)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 2 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 14);
	}
	else if (number == 14)
	{
		if (MatchHasStarted) return;
		Console("msg The match will automatically start in 1 second.");
		Commands->Start_Timer(obj, this, 1.0f, 15);
	}
	else if (number == 20)
	{
		Console("msg The match will start in 10 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 21);
	}
	else if (number == 21)
	{
		Console("msg The match will start in 9 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 22);
	}
	else if (number == 22)
	{
		Console("msg The match will start in 8 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 23);
	}
	else if (number == 23)
	{
		Console("msg The match will start in 7 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 24);
	}
	else if (number == 24)
	{
		Console("msg The match will start in 6 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 25);
	}
	else if (number == 25)
	{
		Console("msg The match will start in 5 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 26);
	}
	else if (number == 26)
	{
		Console("msg The match will start in 4 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 27);
	}
	else if (number == 27)
	{
		Console("msg The match will start in 3 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 28);
	}
	else if (number == 28)
	{
		Console("msg The match will start in 2 seconds.");
		Commands->Start_Timer(obj, this, 1.0f, 29);
	}
	else if (number == 29)
	{
		Console("msg The match will start in 1 second.");
		MatchHasStarted = false;
		Commands->Start_Timer(obj, this, 1.0f, 15);
	}
}

void Reset_Match_Timer::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == RESET_MATCH_CUSTOM)
	{
		Commands->Start_Timer(obj, this, 4.0f, 20);
	}
}
ScriptRegistrant<Reset_Match_Timer> Reset_Match_Timer_Registrant("Reset_Match_Funwar_Or_Clanwar_Timer","");

ClanwarOrFunwar clanwarOrFunwar;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &clanwarOrFunwar;
}
